
  /*
  trimite codul UID pe terminal V12
  RFID alimentare 3.3V, frecventa13.56MHz

  RFID-RC522 conectat
  SS pin    → (nr pin placa 29) GIOP5
  SCK pin   → (30) GIOP18
  MOSI pin  → (37) GIOP23
  MISO pin  → (31) GIOP19
  IRQ pin     (not connected)  
  GND pin → GND
  RST pin →   GPIO4
  VCC pin →   3.3V
  citeste codul tagului
  trimite pe telefon cu Blynk

  compara cu codul prestabilit
  si comanda On OFF ledul placa GPIO 2
  Oled conectat: SDA la GPIO21 SCK la GPIO22
  tot ce se editeaza pe Terminal telefon apare pe Oled
  Optional RGB pe GPIO 12, 14, 27 si 2 (led placa)
  comanda leduri pe GPIO 12, 14, 27
  cu butoane pe D12, 14, 27 fara definitie
    */
 
#include <SPI.h>
#include <MFRC522.h>

#define SS_PIN  5  // ESP32 pin GIOP5 
#define RST_PIN 4
MFRC522 mfrc522(SS_PIN, RST_PIN);   
// Create MFRC522 instance.
 
#define BLYNK_PRINT Serial
#include <WiFi.h>
#include <WiFiClient.h>
#include <BlynkSimpleEsp32.h>

#include <SimpleTimer.h>
SimpleTimer timer;

char auth[] = "e5beac0d31f4433da82dc64b99a03b39"; 

char ssid[] = "UPCF4821BC";
char pass[] = "Gherla1956";

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);

void setup(){
  Serial.begin(115200);

  SPI.begin();
  mfrc522.PCD_Init();   // Initiate MFRC522
  Blynk.begin(auth, ssid, pass);
  timer.setInterval(20L, sendUptime);

  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("RFDI Blynk");
  display.display();
  delay(1000); 
  }

BLYNK_WRITE(V12)//optional
    { //afiseaza pe oled tot ce se editeaza 
      //pe terminal pe telefon
  //Serial.print(param.asInt());
  //trimite numeric
  Serial.print(param.asStr());  
  //trimite string litere si cifre

  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print(param.asStr());
  display.display();
  delay(1000);
    }
    
  void sendUptime(){

  { // sesizeaza prezenta tagului sau cardului
    if ( ! mfrc522.PICC_IsNewCardPresent()) 
  {
    return;
  }
  // Select one of the cards
  if ( ! mfrc522.PICC_ReadCardSerial()) 
  {
    return;
  }
  //Show UID on serial monitor
  Serial.print("UID tag :");
  String content= "";
  byte letter;
  for (byte i = 0; i < mfrc522.uid.size; i++) 
  {
     //Serial.print(mfrc522.uid.uidByte[i] < 0x10 ? " 0" : " ");//optional
     //Serial.print(mfrc522.uid.uidByte[i], HEX); //optional
     content.concat(String(mfrc522.uid.uidByte[i] < 0x10 ? " 0" : " "));
     //content.concat(String(mfrc522.uid.uidByte[i], HEX)); //optional
    content.concat(String(mfrc522.uid.uidByte[i], DEC));
  
  //Serial.print(content[i], DEC); //optional
  Serial.print(content);
  display.clearDisplay(); //afiseaza pe Oled codul UID
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("UID=");
  display.print(content); 
  display.display();
   Blynk.virtualWrite(12, content); //trimite prin Blynk
  }
  Serial.println();
  Serial.print("Message : ");
  content.toUpperCase();
  if (content.substring(1) == "210 230 29 43") 
  //compara codul primit cu cel prestabilit
  //trebuie codul zecimal, adica 210 230 29 43 
  {
    Serial.println("Authorized access");
    Serial.println();
    digitalWrite(2, HIGH); 
    display.print(" access OK"); //daca codul primit coincide cu cel predefinit
    Blynk.virtualWrite(12, " access OK"); //trimite prin Blynk
    
    display.display();
    //delay(1000);
    display.clearDisplay();
  }
 
 else   {
    Serial.println(" Access denied");
    digitalWrite(2, LOW); 
     display.print(" Access denied"); 
     Blynk.virtualWrite(12, " Access denied");
    display.display();
    //delay(1000);
    display.clearDisplay();
 }
  }
    }
  
void loop()
{
Blynk.run(); // Initiates Blynk
  timer.run();
}
